<?php

use App\Http\Controllers\DepartmentForm\DepartmentFormController;
use App\Http\Controllers\FormController;
use App\Http\Controllers\FormGroup\FormGroupController;
use App\Http\Controllers\FormGroupArrange\FormGroupArrangeController;
use App\Http\Controllers\ProjectsForms\ProjectsFormsController;
use App\Http\Controllers\StaticPage\StaticPageController;
use App\Models\Department;
use App\Models\ProjectInput;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::post('/login', [\App\Http\Controllers\AuthController::class, 'login']);
Route::prefix('forms')->group(function () {
    Route::get('/generate-pdf/{projectFormId}', [FormController::class, 'generatePDF']);
    Route::get('/generate-pdf-api/{projectFormId}', [FormController::class, 'generatePDFApi']);
});
// Accessed only by admins
Route::middleware(['ensure.auth'])->group(function () {
    Route::post('/update-user/{userId}', [\App\Http\Controllers\UserController::class, 'updateUser']);
    Route::post('/password/generate-token', [\App\Http\Controllers\AuthController::class, 'generateResetToken']);
    Route::post('/password/reset', [\App\Http\Controllers\AuthController::class, 'resetPassword']);
    Route::get('/users', [\App\Http\Controllers\UserController::class, 'getAllUsers']);
    Route::get('/users/search', [\App\Http\Controllers\UserController::class, 'searchUsers']);
    // Route::get('/users/get/by/{id}', [\App\Http\Controllers\UserController::class, 'getByid']);

    Route::post('/logout', [\App\Http\Controllers\AuthController::class, 'logout']);
    Route::post('/refresh', [\App\Http\Controllers\AuthController::class, 'refresh']);
    Route::post('/add-user', [\App\Http\Controllers\AuthController::class, 'register']);
    Route::get('/users/getUserByType/{type}', [\App\Http\Controllers\UserController::class, 'getUserByType']);
    Route::get('/users/get/by/{id}', [\App\Http\Controllers\UserController::class, 'getByid']);


    Route::prefix('notification-bar')->group(function () {
        Route::namespace('NotificationBar')->group(function () {
            Route::get('/', 'NotificationBarController@index');
            Route::get('/active', 'NotificationBarController@getActive');
            Route::get('/{id}', 'NotificationBarController@show');
            Route::post('/', 'NotificationBarController@store');
            Route::put('/{id}', 'NotificationBarController@update');
            Route::delete('/{id}', 'NotificationBarController@destroy');
        });
    });

// Accessed only by projects
// Route::middleware(['ensure.auth', 'project'])->group(function () {
//     Route::prefix('notification-bar')->group(function () {
//         Route::namespace('NotificationBar')->group(function () {
//             // Route::get('/', 'NotificationBarController@index');
//             // Route::get('/active', 'NotificationBarController@getActive');
//             // Route::get('/get/{id}', 'NotificationBarController@getByid');
//             // Route::post('/add', 'NotificationBarController@add');
//             // Route::patch('/updated', 'NotificationBarController@updated');
//             // Route::get('/delete/{id}', 'NotificationBarController@del');
//         });
//     });
// });


    Route::prefix('forms')->group(function () {
        Route::post('/', 'FormController@store');
        Route::post('/updated', 'FormController@updatedForm');
        Route::patch('/{id}', 'FormController@update');
        // Route::get('/generate-pdf/{projectFormId}', [FormController::class, 'generatePDF']);
        // Route::get('/generate-pdf-api/{projectFormId}', [FormController::class, 'generatePDFApi']);
        Route::get('/last-report/{projectFormId}', [FormController::class, 'lastReport']);
        Route::post('/continue', 'FormController@continue');
        Route::get('/get', 'FormController@getByType');
        Route::get('/get/by/id/{id}', 'FormController@getByid');
        Route::get('/get/all/{type?}', 'FormController@getAll');
        Route::get('/get/by/branch/{id}', 'FormController@getFormByBarnch');
        Route::get('/logs/{id}', 'FormController@getFormsLogs');
        // enums
        Route::prefix('enum')->group(function () {
            Route::get('/getFormType', 'FormController@getFormType');
            Route::get('/getFormPeriodic', 'FormController@getFormPeriodic');
            Route::get('/getFormPeriodicType', 'FormController@getFormPeriodicType');
            Route::get('/getInputType', 'FormController@getInputType');
            Route::get('/getFormChartType', 'FormController@getFormChartType');
            Route::get('/getFormRowSingleMultiColumn', 'FormController@getFormRowSingleMultiColumn');
            Route::get('/getFormRowSingleMultiInput', 'FormController@getFormRowSingleMultiInput');
            Route::get('/getformRowTypeRow', 'FormController@getformRowTypeRow');
            Route::get('/weekDays', 'FormController@weekDays');
        });
    });

    Route::prefix('branch')->group(function () {
        Route::namespace('Branches')->group(function () {
            Route::get('/', 'BranchesControllers@getBranches');
            Route::post('/user', 'BranchesControllers@BranchUser');
            Route::post('/add', 'BranchesControllers@createBranch');
            Route::get('/get/{id}', 'BranchesControllers@showBranch');
            Route::post('/updated', 'BranchesControllers@updateBranch');
            Route::get('/delete/{id}', 'BranchesControllers@del');
        });
    });

    Route::prefix('project')->group(function () {
        Route::namespace('Projects')->group(function () {
            Route::get('/get/by/branch/{id}', 'ProjectsControllers@getByBranchId');
            Route::post('/user', 'ProjectsControllers@projectUsers');
            Route::get('/all', 'ProjectsControllers@getProjects');
            Route::post('/add', 'ProjectsControllers@createProject');
            Route::get('/get/{id}', 'ProjectsControllers@showProject');
            Route::post('/updated', 'ProjectsControllers@updateProject');
            Route::get('/delete/{id}', 'ProjectsControllers@del');
        });
    });

    Route::prefix('dashboard')->group(function () {
        Route::get('/completed', 'ChartDashboard@compelatedFroms');
        Route::get('/completed-and-inCompleted', 'ChartDashboard@compeledAndNotCompaleted');
        Route::get('/info', 'ChartDashboard@info');
        Route::get('/forms/chart/{type}', 'ChartDashboard@getFormsChartFixed');
        Route::get('/forms/chart/chart/{type}/{id}', 'ChartDashboard@getFormsChartChart');
        Route::get('/forms/chart/get/{id}', 'ChartDashboard@FormsChartFixedData');
        Route::get('/forms/chart/input/{id}', 'ChartDashboard@getInputs');
        Route::post('/forms/get/chart', 'ChartDashboard@FormsChartChartData');

    });

    Route::prefix('reports')->group(function () {
        Route::get('/check-form/{id}', 'ReportsControllers@checkFormDisable');
        Route::post('/general', 'ReportsControllers@getGeneralReports');
        Route::post('/calculated', 'ReportsControllers@getCalcutorRepor');
        Route::get('/get/forms/{type}', 'ReportsControllers@getFormsHaveFiles');
        Route::post('/file/zip/url', 'ReportsControllers@getfileReports');

    });

    Route::prefix('project-form')->group(function () {
        Route::namespace('ProjectsForms')->group(function () {
            Route::get('/send-forms', 'ProjectsFormsController@sendForms');
            Route::get('/get-forms/{id}', 'ProjectsFormsController@getProjectForm');
            Route::post('/submit-forms', 'ProjectsFormsController@submitProjectForms');
            Route::post('/change-form-fixed', 'ProjectsFormsController@createFixedForm');
            // Create Complex Form
            Route::post('/change-form-complex', 'ProjectsFormsController@createComplexForm');
            Route::get('/test', 'ProjectsFormsController@test');

        });
    });





// change form status to approved
    Route::put('project-forms/{id}/approve', [ProjectsFormsController::class, 'approve']);


    Route::prefix('department')->group(function () {
        Route::namespace('Department')->group(function () {
            Route::get('/', 'departmentControllers@get');
            Route::get('/get/{id}', 'departmentControllers@getByid');
            Route::post('/add', 'departmentControllers@add');
            Route::post('/updated', 'departmentControllers@updated');
            Route::get('/delete/{id}', 'departmentControllers@del');
        });
    });

// Static Page

    Route::apiResource('static-pages', StaticPageController::class);

// Form Group
    Route::apiResource('form-groups', FormGroupController::class);
// Form Group Arrange
    Route::apiResource('form-group-arranges', FormGroupArrangeController::class);

// Get arrangements by form group id
    Route::get('form-group-arranges/group/{groupId}', [FormGroupArrangeController::class, 'getByGroup']);

// Form Group Arrange bulk operations
    Route::post('form-group-arranges/sync/{formGroupId}', [FormGroupArrangeController::class, 'syncArrangements']);
    Route::put('form-group-arranges/update/{formGroupId}', [FormGroupArrangeController::class, 'updateArrangements']);

// Updated Department Form routes without route parameters
    Route::post('/form/department/attach', [DepartmentFormController::class, 'attachDepartment']);
    Route::delete('/form/department/detach', [DepartmentFormController::class, 'detachDepartment']);

// Updated Department Form routes with route parameters
    Route::get('form-group/department', [FormGroupController::class, 'getFormsByDepartment']);

    Route::put('forms/complex-orders', [FormController::class, 'updateComplexOrders']);
    Route::namespace('ProjectsForms')->group(function () {
        Route::get('/complex-forms/waiting', 'ProjectsFormsController@getWaitingComplexFormsByDepartments');
        Route::get('complex-forms/parents', 'ProjectsFormsController@getParentComplexForms');
        Route::post('complex-forms/waiting/count', 'ProjectsFormsController@countWaitingComplexFormsByDepartments');
        Route::get('complex-forms/{parentId}/children', 'ProjectsFormsController@getChildrenForms');
    });

    Route::get('/roles', 'RoleController@index');
    Route::post('/roles', 'RoleController@store');
    Route::get('/roles/{id}', 'RoleController@show');
    Route::put('/roles/{id}', 'RoleController@update');
//Route::delete('/roles/{id}', 'RoleController@delete');
    Route::get('roles/get/permissions', 'RoleController@getPermissions');

    Route::prefix('activity')->group(function () {
        Route::get('/any/{inlog}/{id}', 'ActivityLogController@index');
        Route::get('/project-form/{id}', 'ActivityLogController@projectForms');

    });
    Route::prefix('related')->group(function () {
        Route::post('/add', 'FormProjectRelatedControllers@add');
        Route::get('/get/{id}', 'FormProjectRelatedControllers@get');
        Route::get('/delete/{id}', 'FormProjectRelatedControllers@del');

    });
});
