<?php

namespace App\Sys\Services\User;

use App\Sys\ApiResponse;
use App\Sys\Repository\User\UserRepo;
use App\Sys\Services;
use validation;

class UserService extends Services
{
    use ApiResponse;

    private $userRepo;

    public function __construct()
    {
        $this->userRepo = new UserRepo();
    }

    public function getbyId($id)
    {
        return $this->userRepo->getByid($id);
    }

    // public function updateUserData($userId, array $data)
    // {
    //     $rules = [
    //         'name' => 'required|string|max:255',
    //         'email' => 'required|string|email|max:255|unique:users,email,' . $userId,
    //         'phone' => 'required|string|max:255',
    //     ];
    //     $valid = validator($data, $rules);
    //     if ($valid->fails()) {
    //         return $this->apiResponse(200, "error", $valid->errors(), null);
    //     }

    //     $user = $this->userRepo->findById($userId);

    //     // Check if we have a user
    //     if (!$user) {
    //         $this->setError('User not found');
    //         return false;
    //     }

    //     return $this->userRepo->update($userId, $data);
    // }

    public function updateUserData($userId, array $data)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        $rules = [
            'name'          => 'required|string|max:255',
            'email'         => 'required|string|email|max:255|unique:users,email,' . $userId,
            'employee_number'   => 'required|string|max:255|unique:users,employee_number,' . $userId,
            'phone'         => 'required|string|max:255',
            'role_id'=>'required|exists:roles,id',
            // Optionally update password if provided
            // 'password'      => 'sometimes|nullable|string|min:6|confirmed',
            // Validate branches if provided (only required if user type is branch)
            'branches'      => 'sometimes|array',
            'branches.*'    => 'exists:branches,id',
            // Validate projects if provided (only required if user type is project)
            'project'       => 'sometimes|array',
            'project.*'     => 'exists:projects,id',
            // Validate departments pivot if provided
            'departments'   => 'sometimes|array',
            'departments.*' => 'exists:department,id',
        ];

        $validator = validator($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }
        // If password is empty, remove it from data to avoid overwriting
        // if (isset($data['password']) && empty($data['password'])) {
        //     unset($data['password']);
        // }

        return $this->userRepo->update($userId, $data);
    }


    public function getUserByType($type)
    {
        return $this->userRepo->getUserByType($type);
    }

    public function getAllUsers($perPage)
    {
        return $this->userRepo->getAllUsers($perPage);
    }

    public function searchUsers()
    {
        return $this->userRepo->searchUsers();
    }
}
