<?php

namespace App\Sys\Services\User;

use App\Sys\Repository\User\RoleRepo;
use App\Sys\Services;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Arr;

class RoleService extends Services
{

    private $role;

    public function __construct()
    {
        $this->role = new RoleRepo();
    }
    public function add($data)
    {
        // flatten your config to a simple list of strings
        $allowed = Arr::flatten(config('global.permissions'));
        $rules = [
            'name'        => 'required|string|unique:roles|max:255',
            'permissions' => [
                'required',
                'array',
                'min:1',
                Rule::in($allowed)        // each element must be in $allowed
            ],
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        return $this->role->add($data);
    }

    public function updated($data, $id)
    {
        $allowed = Arr::flatten(config('global.permissions'));

        $rules = [
            'name'        => ['sometimes', 'string', 'unique:roles,name,' . $id, 'max:255'],
            'permissions' => [
                'sometimes',
                'array',
                'min:1',
                Rule::in($allowed)
            ],
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        $data['id'] = $id;
        return $this->role->updated($data);
    }

    public function gets()
    {
        return $this->role->gets();
    }

    public function get($id = 0)
    {
        $data =  $this->role->getByid($id);
        if (!empty($data))
            return $data;


        return  false;
    }

    public function getAll()
    {
        return $this->role->getAll();
    }

    public function delete($id)
    {
        return $this->role->delete($id);
    }
    public function getPermissions()
    {
        return config('global.permissions');
    }
}
