<?php

namespace App\Sys\Services;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\App;
class UploadFile
{

    public static function uploadFile($file_data, $mimeType)
    {
        if($file_data != null && $mimeType != null)
        {
            $extensions = [
                'image/jpeg' => 'jpg',
                'image/jpg' => 'jpeg',
                'image/png' => 'png',
                'application/pdf' => 'pdf',
            ];
            $file_data = base64_decode($file_data);
            $extension = $extensions[$mimeType];
            $filename = Str::random(40) . '.' . $extension;
            if (!file_exists(public_path('uploads/projectForms'))) {
                File::makeDirectory(public_path('uploads/projectForms'), 0777, true, true);
            }
            $path = public_path('uploads/projectForms/' . $filename);
            file_put_contents($path, $file_data);
            return 'uploads/projectForms/' . $filename;
        }
        return null;
    }

    public static function mime2ext($mime_type)
    {

        return $extensions[$mime_type] ?? '';
    }
}
