<?php

namespace App\Sys\Services\ProjectsFroms;

use App\Models\ProjectForm;
use App\Models\ProjectInput;
use App\Sys\Repository\formComplexGroupsRepo;
use App\Sys\Repository\FormRepo;
use App\Sys\Repository\Forms\FormBranchProjectRepo;
use App\Sys\Repository\Projects\ProjectsRepo;
use App\Sys\Repository\ProjectsForms\ProjectFormInputsRepo;
use App\Sys\Repository\ProjectsForms\ProjectsFormsRepo;
use App\Sys\Services;
use Carbon\Carbon;
use Illuminate\Support\Facades\App;
use validation;

class ProjectsFormServices extends Services
{
    private $projectFrom;
    private $forms;
    private $FBPRepo;
    private $project;

    private $projectFormInput;
    private $formComplaxGroup;

    public function __construct()
    {
        $this->projectFrom = new ProjectsFormsRepo();
        $this->forms = new FormRepo();
        $this->FBPRepo = new FormBranchProjectRepo();
        $this->projectFormInput = new ProjectFormInputsRepo();
        $this->project = new ProjectsRepo();
        $this->formComplaxGroup = new formComplexGroupsRepo();
    }

    public function count()
    {
        return $this->projectFrom->count();
    }

    public function addProjectFrom($form)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        if (!isset($data['user_id'])) {
            $data['user_id'] = auth()->id() ?? null;
        }

        $fromProject = $this->FBPRepo->getByFromID($form['id']);
        foreach ($fromProject as $pro) {
            $data = [
                'project_id' => $pro->project_id,
                'form_id' => $form['id'],
                'branch_id' => $pro->branch_id,
                'type' => $form['type'],
                'expiration_date' => Carbon::now()->addDays($form['deadline_by_num_of_days']),
                'chart' => $form['chart'],
                'approved' => $form['approved'],
                'status' => 'waiting'

            ];
            $addForm = $this->projectFrom->SendForm($data);
            $this->addinputs($addForm, $form);
        }
    }

    public function addinputs($projectFormId, $form)
    {
        foreach ($form['form_input'] as $input) {
            $data = [
                'project_form_id' => $projectFormId,
                'form_id' => $form['id'],
                'input_id' => $input['id'],
                'answer' => null,
                'input_type' => $input['input_type'],
                'file_type' => null,
                'calculated' => $input['calculated'],
                'placeholder' => $input['placeholder'],
                'value' => $input['value'],
                'show_pdf' => $input['show_pdf'],
                'show_on_fill' => $input['show_on_fill'],
                'required' => $input['required'],
                'chart' => $input['chart'],
                'chart_type' => $input['chart_type'],
                'icon' => $input['icon'],
                'form_row_id' => $input['form_row_id'],
                'form_column_id' => $input['form_column_id'],
                'form_sub_column_id' => $input['form_sub_column_id'],
                'writing_mode' => $input['writing_mode'],
                'form_sub_row_id' => $input['form_sub_row_id'],
            ];
            $this->projectFormInput->addInputs($data);
        }
    }

    public function addFormFixed($data, $ref = null)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        if (!isset($data['user_id'])) {
            $data['user_id'] = auth()->id() ?? null;
        }
        // check user have permissions in this projects
        if(!Auth()->user()->userProjects()->where('project_id', $data['project_id'])->exists())
        {
            return false;
        }
        $project = new ProjectsRepo();
        $getProject = $project->getProjectById($data['project_id']);
        $form = new FormRepo();
        $getForm = $form->getFormById($data['form_id']);
        $data = [
            'project_id' => $getProject->id,
            'form_id' => $getForm->id,
            'branch_id' => $getProject->branch_id,
            'type' => $getForm->type,
            'expiration_date' => null,
            'chart' => $getForm->chart,
            'approved' => $getForm->approved,
            'status' => 'waiting',
            'ref' => $ref

        ];
        $addForm = $this->projectFrom->SendForm($data);
        $this->addinputs($addForm, collect($getForm)->toArray());

        return $addForm;
    }

    public function addFormComplex($data)
    {
        $rules = [
            'project_id' => 'required|exists:projects,id',
            'form_id' => 'required|exists:forms,id,order_of_cycle,1',
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }
        $ref = uniqid();
        $id = $this->addFormFixed($data, $ref);
        $group = $this->forms->getFormById($data['form_id']);
        $project = $this->project->getProjectById($data['project_id']);
        $fromGroup = $this->forms->getFormsBygroup($group->form_group_id, $data['form_id']);
        $parrentgroup = [
            'form_id' => $data['form_id'],
            'project_form_id' => $id,
            'project_id' => $project->id,
            'branch_id' => $project->branch_id,
            'form_group_id' => $group->form_group_id,
            'status' => 'waiting',
            'parent_id' => 0,
            'refeferal_code' => $ref,
            'user_id' => null
        ];
        $parrent = $this->formComplaxGroup->add($parrentgroup);
        foreach ($fromGroup as $form) {
            $parrentFroup = [
                'form_id' => $form->id,
                'project_form_id' => null,
                'project_id' => $project->id,
                'branch_id' => $project->branch_id,
                'form_group_id' => $group->form_group_id,
                'status' => null,
                'parent_id' => $parrent,
                'refeferal_code' => $ref,
                'user_id' => null
            ];
            $this->formComplaxGroup->add($parrentFroup);
        }
        return $id;
    }

    public function getInputsForForm($form_id)
    {
        $form = $this->projectFrom->getProjectForm($form_id);
        if (empty($form)) {
            $this->setError(['Not Found Form']);
            return false;
        }

        $myFiles = [];
        if ($form->form->files != null) {
            foreach ($form->form->files as $file) {
                if (file_exists(public_path() . '/' . $file->path)) {
                    $myFiles[] = [
                        'name' => $file->file_name,
                        'type' => $file->type,
                        'path' => url('/' . $file->path)
                    ];
                }
            }
        }


        $rows = $this->projectFrom->getInputsForForm($form_id);
        $exam = [];
        $count = 0;
        $page = 0;
        $addInput = [];
        $canPermissions = [
            'complex' => 'SEND_COMPLEX_FORM',
            'fixed' => 'SEND_FIXED_FORM',
            'general'=>"SEND_FOLLOW_UP_FORM",
        ];
        $approvePermissions = [
            'complex' => "APPROVE_COMPLEX_FORM",
            'fixed' =>"APPROVE_FIXED_FORM",
            'general'=>"APPROVE_FOLLOW_UP_FORM"
        ];
        foreach ($rows as $row) {
            if (!isset($exam[$page])) {
                $exam[$page] = [];
            }
            if ($row['single_multi_input'] == 'single_input') {
                $addInput = [];
                foreach ($row['getProjectInputs'] as $input) {
                    $ruternInput = $this->getDataInput($input);
                    if($ruternInput !== false){
                        $addInput[] = $this->getDataInput($input);
                    }

                }
                if ($count >= 5) {
                    $page++;
                    $count = 0;
                    $exam[$page] = [];
                }
                $exam[$page][] = $addInput;
                $count++;
            } else {
                foreach ($row['getProjectInputs'] as $input) {
                    $set = $this->getDataInput($input);
                    if($set !== false){

                        if ($count >= 5) {
                            $page++;
                            $count = 0;
                            $exam[$page] = [];
                        }

                        $exam[$page][] = $set;
                    }
                    $count++;
                }
            }
        }
        return [
            'form_name' => $form->form->name ?? null,
            'form_desc' => $form->form->description ?? null,
            'status' => $form->status,
            'type' => $form->type,
            'user_submit_permissions'=>auth()->user()->can($canPermissions[$form->type]),
            'user_approve_permissions'=>auth()->user()->can($approvePermissions[$form->type]),
            "can_submit" => in_array($form->status, ['waiting', 'waiting_approved']) ? true : false,
            'project_form_id' => $form_id,
            'inputs' => array_values(array_filter($exam)),
            'files' => $myFiles
        ];
    }

    public function getDataInput($input)
    {
        if(in_array($input['input_type'],['creator','approver'])){
            return false;
        }

        if($input['show_on_fill'] == 0 && $input['input_type'] == 'label'){
            return false;
        }
        return [
            'id' => $input['id'],
            'answer' => $input['answer'],
            'input_type' => $input['input_type'],
            'placeholder' => $input['placeholder'],
            'value' => $input['value'],
            'show_on_fill' => $input['show_on_fill'],
            'required' => $input['required'],
            'label' => $input['inputs']['label'],
            'option' => $input['inputs']['getOption']
        ];
    }

    public function sbmit($data)
    {
        $last_page = isset($data["last_page_submit"]) ? $data["last_page_submit"] : true;
        $inputIds = [];
        if (!empty($data['inputs'])) {
            foreach ($data['inputs'] as $input) {
                $name = null;
                if ($input['type'] == 'file') {

                    $name = Services\UploadFile::uploadFile($input['value'], $input['file_type']);
                }
                $this->projectFrom->updatedProjectInput($input, $name);
            }
            $inputIds = array_column($data['inputs'], 'id');
        }


        if ($last_page == true) {
            $check = $this->projectFrom->checkFroNullInput($data['project_form_id'], $inputIds);
            if (empty($check)) {
                $projectForm = $this->projectFrom->updatedForms($data['project_form_id']);
                if ($projectForm->type == "complex") {
                    $this->formComplaxGroup->updatedCurrent($projectForm);
                    $this->nextStepComplex($projectForm);
                }
            }
        }


        return true;
    }


    public function nextStepComplex($form)
    {
        $check = $this->formComplaxGroup->getNextForm($form);
        if (!empty($check)) {
            $data['project_id'] = $check->project_id;
            $data['form_id'] = $check->form_id;
            $ref = $check->reference_code;
            $id = $this->addFormFixed($data, $ref);
            $this->formComplaxGroup->updated($check->id, $id);
        }
    }

    public function gets($data)
    {
        return $this->projectFrom->getData();
    }

    /**
     * Approve a project form.
     *
     * @param int $projectFormId The ID of the project form to approve.
     * @param int $userBranchId The branch ID of the authenticated user.
     * @return ProjectForm|false The updated project form or false on failure.
     */

    public function approveForm($projectFormId)
    {
        // Ensure that only authenticated users can create a form.
        $projectForm = ProjectForm::find($projectFormId);
        if (!$projectForm) {
            $this->setError("Project form not found");
            return false;
        }
        // Optionally check the status if needed:
        if (!in_array($projectForm->status, ['waiting_approved'])) {
            $this->setError("Project form status waiting_approved to be approved");
            return false;
        }

        return $this->projectFrom->approveForm($projectFormId);


        return $projectForm;
    }

    public function FormChartFixed($id)
    {
        $branches = $this->projectFrom->FormChartFixed($id);
        $requiredLabels = [];
        $formId = $id;
        return $branches->map(function ($branch) use ($formId, &$requiredLabels) {
            $formInputs = $branch->getProjectForm->where('form_id', $formId)
                ->flatMap(fn($form) => $form->projectFormInputs)
                ->where('input_type', 'number')
                ->where('chart', 1)
                ->where('chart_type', 'fixed');
            $answers = $formInputs->map(function ($input) use (&$requiredLabels) {
                $label = $input->inputs->label;
                $icon = $input->inputs->icon;
                $requiredLabels[$label] = $icon;
                return [
                    'label' => $label,
                    'icon' => $icon,
                    'answer' => $input->answer,
                ];
            });
            $totalAnswersByLabel = $answers->groupBy('label')->map(function ($group) {
                return [
                    'total_answer' => $group->sum('answer'),
                    'label' => $group->first()['label'],
                    'icon' => $group->first()['icon'],
                ];
            });
            $finalAnswers = collect($requiredLabels)->map(function ($icon, $label) use ($totalAnswersByLabel) {
                return [
                    'total_answer' => $totalAnswersByLabel->get($label, ['total_answer' => 0])['total_answer'] ?? 0,
                    'label' => $label,
                    'icon' => $icon,
                ];
            })->values();

            return [
                'branch_name' => $branch->name,
                'answers' => $finalAnswers,
            ];
        });
    }

    public function chart($parameter)
    {
        $rules = [
            'branch_id' => 'required|exists:branches,id',
            'form_id' => 'required|exists:forms,id',
            'input_id' => 'required|exists:form_inputs,id',
            'from' => "required|date|before_or_equal:to",
            'to' => "required|date|after_or_equal:from"
        ];

        $validator = validator($parameter, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        $projectForms = $this->projectFrom->getChart($parameter);
        $data = [];
        $named = [];
        $values = [];
        $colors = [];
        $created_at = [];
        foreach ($projectForms as $projectForm) {
            if (!isset($data[$projectForm->project->name])) {
                $data[$projectForm->project->name] = [
                    'color' => $this->getRandomColor()
                ];
            }
            if (!in_array($projectForm->project->name, $named)) {
                $named[] = $projectForm->project->name;
                $colors[] = $this->getRandomColor();
            }
            $data[$projectForm->project->name]['answers'][] = $projectForm->projectFormInputs->first()->answer ?? 0;
            $values[] = (int)$projectForm->projectFormInputs->first()->answer ?? 0;
            if (!in_array($projectForm->created_at->format('Y-m-d'), $created_at)) {
                $created_at[] = $projectForm->created_at->format('Y-m-d');
            }
        }
        $unique_dates = $created_at;
        return [
            'dates' => $unique_dates,
            'colors' => $colors,
            'values' => $values,
            'named' => $named,
            'data' => $data
        ];
    }

    private function getRandomColor()
    {
        $letters = '0123456789ABCDEF';
        $color = '#';
        for ($i = 0; $i < 6; $i++) {
            $color .= $letters[rand(0, 15)];
        }
        return $color;
    }

    public function getWaitingComplexFormsByDepartments()
    {
        return $this->formComplaxGroup->getWaitingByDepartmentIds();
    }

    public function countWaitingByDepartmentIds(array $departmentIds,$projects)
    {
        return $this->formComplaxGroup->countWaitingByDepartmentIds($departmentIds,$projects);
    }

    public function getCilderandPerant($id, $limit = 30)
    {
        return $this->formComplaxGroup->getCilderandPerant($id, $limit);
    }

    public function getParentForms()
    {
        return $this->formComplaxGroup->getParentForms();
    }
}
