<?php

namespace App\Sys\Services\NotificationBar;

use App\Sys\Repository\NotificationBar\NotificationBarRepo;
use App\Sys\Services;
use Illuminate\Support\Facades\Validator;

class NotificationBarServices extends Services
{
    private $notif;

    public function __construct()
    {
        $this->notif = new NotificationBarRepo();
    }

    /**
     * Validate and create a new notification bar.
     *
     * @param array $data
     * @return mixed  Returns the created model or false if validation fails.
     */
    public function add(array $data)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        if (!isset($data['user_id'])) {
            $data['user_id'] = auth()->id() ?? null;
        }

        $rules = [
            'text'   => 'required|string',
            'active' => 'required|integer'
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        return $this->notif->create($data);
    }

    /**
     * Validate and update an existing notification bar.
     *
     * @param array $data Must include the 'id' key.
     * @return mixed  Returns the updated model or false if validation fails.
     */
    public function updated(array $data)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        if (!isset($data['user_id'])) {
            $data['user_id'] = auth()->id() ?? null;
        }

        $rules = [
            'id'     => 'required|integer',
            'text'   => 'sometimes|string',
            'active' => 'sometimes|integer'
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        return $this->notif->update($data['id'], $data);
    }

    /**
     * Retrieve all notification bars.
     */
    public function get()
    {
        return $this->notif->get();
    }

    /**
     * Retrieve a single notification bar by its ID.
     */
    public function getByid($id)
    {
        return $this->notif->find($id);
    }

    public function getActive()
    {
        return $this->notif->getActive();
    }

    /**
     * Delete a notification bar.
     */
    public function del($id)
    {
        try {
            $this->notif->find($id); // Throws exception if not found
        } catch (\Exception $e) {
            $this->setError('Not Found');
            return false;
        }
        return $this->notif->delete($id);
    }
}
