<?php

namespace App\Sys\Services;

use App\Sys\Repository\FormProjectRelatedRepo;
use App\Sys\Services;
use validation;
class FormProjectRelatedServices extends Services
{

    private $projectRelatedRepo;

    public function __construct()
    {
        $this->projectRelatedRepo = new FormProjectRelatedRepo();
    }

    public function add($data)
    {
        $rules = [
            'id' => 'required|exists:project_forms,id',
            'form_id' => 'required|exists:project_forms,id',
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return  $this->projectRelatedRepo->add($data);
    }

    public function del($id)
    {
        $data= ['id' => $id];
        $rules = [
            'id' => 'required|exists:form_related,id',
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return  $this->projectRelatedRepo->del($id);
    }

    public function get($id)
    {
        return $this->projectRelatedRepo->get($id);
    }

}
