<?php

namespace App\Sys\Services\FormGroup;

use App\Sys\Repository\FormGroup\FormGroupRepository;
use App\Sys\Services;

class FormGroupService extends Services
{
    private $formGroupRepo;

    public function __construct()
    {
        $this->formGroupRepo = new FormGroupRepository();
    }

    public function add($data)
    {
        $rules = [
            'name' => 'required|string|max:255',
            'paper_type' => 'required|string|in:' . implode(',', \App\Sys\Enums::formGroupPaperEnum()),
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return $this->formGroupRepo->create($data);
    }

    public function update($data)
    {
        $rules = [
            'id'       => 'required',
            'name' => 'sometimes|string|max:255',
            'paper_type' => 'sometimes|string|in:' . implode(',', \App\Sys\Enums::formGroupPaperEnum()),
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return $this->formGroupRepo->update($data['id'], $data);
    }

    public function get()
    {
        return $this->formGroupRepo->all();
    }

    public function getByid($id)
    {
        try {
            return $this->formGroupRepo->find($id);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            $this->setError('Form group not found');
            return false;
        }
    }

    public function del($id)
    {
        $del = $this->formGroupRepo->find($id);
        if (!empty($del)) {
            return $this->formGroupRepo->delete($id);
        }
        $this->setError('Not Found');
        return false;
    }

    /**
     * Get forms filtered by department and/or form name with pagination.
     *
     * @param mixed|null $department Department id or name (optional).
     * @param string|null $formName Optional form name to search for.
     * @param int $limit Pagination limit.
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function getFormsByFilters($departmentIds = null, $formName = null, $limit = 10)
    {
        return $this->formGroupRepo->getFormsByFilters($departmentIds, $formName, $limit);
    }
}
