<?php

namespace App\Sys\Services\Department;

use App\Sys\Repository\Department\DepartmentRepo;
use App\Sys\Services;

class DepartmentServices extends Services
{

    private $department;

    public function __construct()
    {
        $this->department = new DepartmentRepo();
    }

    public function add($data)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        if (!isset($data['user_id'])) {
            $data['user_id'] = auth()->id() ?? null;
        }

        $rules = [
            'name' => 'required|string|max:255|unique:department,name',
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return $this->department->add($data);
    }
    public function updated($data)
    {
        // Ensure that only authenticated users can create a form.


        // This will use the currently authenticated user if available.
        if (!isset($data['user_id'])) {
            $data['user_id'] = auth()->id() ?? null;
        }

        $rules = [
            'id' => 'required',
            'name' => 'required|string|max:255|unique:department,name,' . $data['id'],
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return $this->department->updated($data);
    }

    public function get()
    {
        return $this->department->getAll();
    }

    public function getByid($id)
    {
        return $this->department->getByid($id);
    }

    public function del($id)
    {
        $del = $this->department->getByid($id);
        if (!empty($del))
            return $this->department->del($id);


        $this->setError('Not Found');
        return  false;
    }
}
