<?php

namespace App\Sys\Repository;

use App\Models\formComplexGroups;
use App\Models\FormGroup\FormGroup;

class formComplexGroupsRepo
{


    public function add($data)
    {
        $add = new formComplexGroups();
        $add->form_id = $data['form_id'];
        $add->project_form_id = $data['project_form_id'];
        $add->project_id = $data['project_id'];
        $add->branch_id = $data['branch_id'];
        $add->form_group_id = $data['form_group_id'];
        $add->status = $data['status'];
        $add->parent_id = $data['parent_id'];
        $add->reference_code = $data['refeferal_code'];
        $add->user_id = $data['user_id'];
        $add->save();
        return $add->id;
    }

    public function getNextForm($form)
    {
        $formGroup = $form->form->form_group_id ?? null;
        return formComplexGroups::where([
            ['form_group_id', $formGroup],
            ['reference_code', $form->reference_code],
            ['project_form_id', null]
        ])->first();
    }

    public function updated($id, $projectForm_id)
    {
        $updated = formComplexGroups::find($id);
        $updated->project_form_id = $projectForm_id;
        $updated->status = 'waiting';
        return $updated->save();
    }

    public function updatedStatus($id, $status)
    {
        $updated = formComplexGroups::find($id);
        $updated->status = $status;
        return $updated->save();
    }

    public function updatedCurrent($forms)
    {
        $comlax = formComplexGroups::where([
            ['reference_code', $forms->reference_code],
            ['project_form_id', $forms->id]
        ])->first();
        $comlax->status = $forms->status;
        $comlax->user_id = Auth()->user()->id;
        return $comlax->save();
    }

    public function getByReference($reference)
    {
        return formComplexGroups::where('reference_code', $reference)->get();
    }


    public function getWaitingByDepartmentIds()
    {
        $form_name = request('form_name');
        $form_group_id = request('form_group_id');
        $limit = request('limit', 20);
        $branch = request()->has('branch_id') && request()->branch_id !== null ? explode(',', request()->branch_id) : null;
        $project = request()->has('project_id') && request()->project_id !== null ? explode(',', request()->project_id) : null;
        $department = request()->has('department_ids') && request()->department_ids !== null ? explode(',', request()->department_ids) : null;
        $user_id = request()->user_id;
        return formComplexGroups::with(['form.departments', 'form.formGroup','creator','project','branch'])
            ->where([['status', 'waiting'],
                ['project_form_id', '!=', null]
            ])
            ->when($form_name, function ($q) use ($form_name) {
                $q->whereHas('form', function ($subQuery) use ($form_name) {
                    $subQuery->where('name', 'like', '%' . $form_name . '%');
                });
            })->when($department, function ($q) use ($department) {
                $q->whereHas('form.departments', function ($q) use ($department) {
                    $q->whereIn('department_id', $department);
                });
            })->when($branch, function ($q) use ($branch) {
                $q->whereIn('branch_id', $branch);
            })->when($user_id, function ($q) use ($user_id) {
                $q->where('user_id', $user_id);
            })->when($project, function ($q) use ($project) {
                $q->whereIn('project_id', $project);
            })->when($form_group_id, function ($q) use ($form_group_id) {
                $q->whereIn('form_group_id', $form_group_id);
            })->paginate($limit);

        /*
         *
         *  ->whereHas('form', function ($query) use ($departmentIds, $formName) {
                $query->where('type', 'complex')
                    // Use 'when' to conditionally add department filter.
                    ->when(!empty($departmentIds) && !in_array(null, $departmentIds, true), function ($query) use ($departmentIds) {
                        $query->whereHas('departments', function ($q) use ($departmentIds) {
                            $q->whereIn('department_id', $departmentIds);
                        });
                    })
                    // Use 'when' to conditionally add form name filter.
                    ->when($formName, function ($query) use ($formName) {
                        $query->where('name', 'like', '%' . $formName . '%');
                    });
            });
         */
    }

    public function countWaitingByDepartmentIds(array $departmentIds,$project)
    {
        return formComplexGroups::where('status', 'waiting')
            ->whereHas('form', function ($query) use ($departmentIds) {
                $query->where('type', 'complex')
                    ->whereHas('departments', function ($q) use ($departmentIds) {
                        $q->whereIn('department_id', $departmentIds);
                    });
            })->whereIn('project_id', $project)->count();
    }

    public function getParentForms()
    {
        $form_id = request('form_id');
        $form_name = request('form_name');
        $form_group_id = request('form_group_id');
        $limit = request('limit', 20);
        $branch = request()->has('branch_id') && request()->branch_id !== null ? explode(',', request()->branch_id) : null;
        $project = request()->has('project_id') && request()->project_id !== null ? explode(',', request()->project_id) : null;
        $department = request()->has('department') && request()->department !== null ? explode(',', request()->department) : null;
        return formComplexGroups::with(['form.departments','creator','project','branch'])
            ->when($form_id, function ($q) use ($form_id) {
                $q->where('form_id', $form_id);
            })->when($form_name, function ($q) use ($form_name) {
                $q->whereHas('form', function ($subQuery) use ($form_name) {
                    $subQuery->where('name', 'like', '%' . $form_name . '%');
                });
            })->when($department, function ($q) use ($department) {
                $q->whereHas('form.departments', function ($q) use ($department) {
                    $q->whereIn('department_id', $department);
                });
            })->when($branch, function ($q) use ($branch) {
                $q->whereIn('branch_id', $branch);
            })->when($project, function ($q) use ($project) {
                $q->whereIn('project_id', $project);
            })->when($form_group_id, function ($q) use ($form_group_id) {
                $q->whereIn('form_group_id', $form_group_id);
            })->where('parent_id', 0)->orderBy('updated_at','desc')->paginate($limit);
    }

    public function getChildrenByParentId($parentId, $limit = 15, $filters = [])
    {
        $query = formComplexGroups::where('parent_id', $parentId)
            ->with(['form.departments', 'parent']);

        return $query->paginate($limit);
    }

    public function getCilderandPerant($parentId, $limit)
    {
        return formComplexGroups::with('form.departments','creator','project','branch')
            ->where('id', $parentId)
            ->orWhere('parent_id', $parentId)
            ->paginate($limit);
    }

    public function getGroup($id)
    {
        return FormGroup::find($id);
    }
}
