<?php

namespace App\Sys\Repository\User;

use App\Models\Role;

class RoleRepo
{
    private $role;

    public function __construct()
    {
        $this->role = new Role();
    }

    public function add($data)
    {
        $this->role->name = $data['name'];
        $this->role->permissions = $data['permissions'];
        return $this->role->save();
    }

    public function updated($data)
    {
        $role = $this->role->find($data['id']);

        if (array_key_exists('name', $data)) {
            $role->name = $data['name'];
        }

        if (array_key_exists('permissions', $data)) {
            $role->permissions = $data['permissions'];
        }

        return $role->save();
    }


    public function gets()
    {
        return $this->role->orderBy('created_at', 'asc')->get();
    }
    public function getAll()
    {
        return $this->role->get();
    }

    public function getByid($id = 0)
    {
        return $this->role->find($id);
    }

    public function delete($id)
    {
        return $this->role->destroy($id);
    }

}
