<?php

namespace App\Sys\Repository\StaticPage;

use App\Models\StaticPage\StaticPage;

class StaticPageRepository
{
    public function all()
    {
        return StaticPage::with('creator')->get();
    }

    public function find($id)
    {
        return StaticPage::with('creator')->findOrFail($id);
    }

    public function create(array $data)
    {
        $data['user_id'] = auth()->id();
        return StaticPage::create($data);
    }

    public function update($id, array $data)
    {
        $page = $this->find($id);
        $page->user_id = auth()->id();
        $page->title_en = $data['title_en'];
        $page->title_ar = $data['title_ar'];
        $page->body_en = $data['body_en'];
        $page->body_ar = $data['body_ar'];
        $page->cover = $data['image'] ?? $page->cover;
        $page->save();
        return $page;
    }

    public function delete($id)
    {
        $page = $this->find($id);
        $page->delete();
        return true;
    }

}
