<?php

namespace App\Sys\Repository\FormGroupArrange;

use App\Models\FormGroupArrange\FormGroupArrange;
use App\Models\Form; // Import the Form model

class FormGroupArrangeRepository
{
    public function getByGroup($groupId)
    {
        return FormGroupArrange::with('form')
            ->where('form_group_id', $groupId)
            ->orderBy('order_of_cycle')
            ->orderBy('order_of_arrangement')
            ->get();
    }

    public function syncGroupArrangements($formGroupId, array $arrangements)
    {
        // Delete existing arrangements for this group
        FormGroupArrange::where('form_group_id', $formGroupId)->delete();

        // Create new arrangements and update the corresponding form record
        $created = [];
        foreach ($arrangements as $arrangement) {
            $record = FormGroupArrange::create([
                'form_id' => $arrangement['form_id'],
                'form_group_id' => $formGroupId,
                'order_of_cycle' => $arrangement['order_of_cycle'],
                'order_of_arrangement' => $arrangement['order_of_arrangement']
            ]);
            $created[] = $record;

            // Update the Form record with the new ordering values
            Form::where('id', $arrangement['form_id'])->update([
                'order_of_cycle' => $arrangement['order_of_cycle'],
                'order_of_arrangement' => $arrangement['order_of_arrangement'],
                'form_group_id' => $formGroupId,
            ]);
        }

        return $created;
    }

    public function updateGroupArrangements($formGroupId, array $arrangements)
    {
        $updated = [];

        foreach ($arrangements as $arrangement) {
            $record = FormGroupArrange::where('form_group_id', $formGroupId)
                ->where('form_id', $arrangement['form_id'])
                ->first();

            if ($record) {
                $record->update([
                    'order_of_cycle' => $arrangement['order_of_cycle'],
                    'order_of_arrangement' => $arrangement['order_of_arrangement']
                ]);
                $updated[] = $record;

                // Also update the corresponding Form record
                Form::where('id', $arrangement['form_id'])->update([
                    'order_of_cycle' => $arrangement['order_of_cycle'],
                    'order_of_arrangement' => $arrangement['order_of_arrangement'],
                    'form_group_id' => $formGroupId,
                ]);
            }
        }

        return $updated;
    }

    public function all()
    {
        return FormGroupArrange::all();
    }

    public function find($id)
    {
        return FormGroupArrange::findOrFail($id);
    }

    public function create(array $data)
    {
        return FormGroupArrange::create($data);
    }

    public function update($id, array $data)
    {
        $record = $this->find($id);
        $record->update($data);
        return $record;
    }

    public function delete($id)
    {
        $record = $this->find($id);
        $record->delete();
        return true;
    }
}
