<?php

namespace App\Sys\Repository\DepartmentForm;

use App\Models\Form;

class DepartmentFormRepo
{
    /**
     * Attach a department to the form.
     *
     * @param Form   $form
     * @param int    $departmentId
     * @param int|null $formGroupId
     * @return void
     */
    public function attachDepartment(Form $form, array $departmentIds, ?int $formGroupId = null)
    {
        foreach ($departmentIds as $departmentId) {
            $pivotData = [];
            if ($formGroupId) {
                $pivotData['form_group_id'] = $formGroupId;
            }

            if (!$form->departments()->where('department.id', $departmentId)->exists()) {
                $form->departments()->attach($departmentId, $pivotData);
            } else {
                $form->departments()->updateExistingPivot($departmentId, $pivotData);
            }
        }
    }

    /**
     * Detach a department from the form.
     *
     * @param Form $form
     * @param int  $departmentId
     * @return void
     */
    public function detachDepartment(Form $form, int $departmentId)
    {
        $form->departments()->detach($departmentId);
    }
}
