<?php

namespace App\Sys;

trait LogsModelActivity
{
    public function logActivity($logName,$model, string $action, array $related = [],$originalModel = null): void
    {
        $oldAttributes = [];
        $newAttributes = [];

        if ($action === 'updated') {
            $oldAttributes = $originalModel?->getAttributes() ?? $model->getOriginal();
            $newAttributes = $model->getAttributes();
        } elseif ($action === 'created') {
            $newAttributes = $model->getAttributes();
        } elseif ($action === 'deleted') {
            $oldAttributes = $model->getAttributes();
        }

        foreach ($related as $relationKey => $relation) {
            if ($action === 'updated' || $action === 'deleted') {
                $oldAttributes[$relationKey] = collect($relation['old'])->map(function ($item) {
                    return [
                        'id' => is_object($item) ? $item->id : $item['id'] ?? null,
                        'name' => is_object($item) ? $item->name : $item['name'] ?? null,
                    ];
                })->toArray();
            }

            if ($action === 'updated' || $action === 'created') {
                $newAttributes[$relationKey] = collect($relation['new'])->map(function ($item) {
                    return [
                        'id' => is_object($item) ? $item->id : $item['id'] ?? null,
                        'name' => is_object($item) ? $item->name : $item['name'] ?? null,
                    ];
                })->toArray();
            }
        }

        activity($logName)
            ->performedOn($model)
            ->causedBy(auth()->user())
            ->event($action)
            ->withProperties([
                'attributes' => [
                    'old' => $oldAttributes,
                    'new' => $newAttributes,
                ]
            ])
            ->log($action);
    }

    private function formatAttributes(array $attributes)
    {
        return array_map(function ($value) {
            return is_array($value) ? json_encode($value) : $value;
        }, $attributes);
    }
}
