<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Arr;


class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // flatten to [ 'view-sliders', 'add-pages', ... ]
        $all = Arr::flatten(config('global.permissions'));

        foreach ($all as $permission) {
            Gate::define($permission, function ($user) use ($permission) {
                return $user->hasAbility($permission);
            });
        }
    }
}
