<?php

namespace App\Models\StaticPage;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class StaticPage extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [
        'title_en',
        'title_ar',
        'body_en',
        'body_ar',
        'cover',
        'user_id'
    ];
    protected static $logAttributes = ['*'];
    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(static::$logAttributes)
            ->logOnlyDirty()
            ->useLogName('static_page')
            ->dontSubmitEmptyLogs();
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $getPath = function ($attributes) {
            if (isset($attributes['cover']) && $attributes['cover']) {
                $attributes['cover'] = asset('/' .$attributes['cover']);
            }
            return $attributes;
        };

        $attributes = [
            'old' => [],
            'new' => [],
        ];

        if ($eventName === 'created') {
            $attributes['new'] = $getPath($this->getAttributes());
        } elseif ($eventName === 'updated') {
            $attributes['old'] = $getPath($this->getOriginal());
            $attributes['new'] = $getPath($this->getAttributes());
        } elseif ($eventName === 'deleted') {
            $attributes['old'] = $getPath($this->getOriginal());
        }

        $attributes['old'] = $this->formatTimestamps($attributes['old']);
        $attributes['new'] = $this->formatTimestamps($attributes['new']);
        $activity->properties = ['attributes' => $attributes];
    }
    protected function formatTimestamps(array $attributes): array
    {
        foreach (['created_at', 'updated_at'] as $key) {
            if (isset($attributes[$key])) {
                try {
                    $attributes[$key] = \Carbon\Carbon::parse($attributes[$key])->format('Y-m-d H:i:s');
                } catch (\Exception $e) {

                }
            }
        }

        return $attributes;
    }
    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
