<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Role extends Model
{
    use HasFactory, LogsActivity;
    protected $table = "roles";

    protected static $logAttributes = ['*'];
    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;


    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(static::$logAttributes)
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs()
            ->useLogName('role')
            ->setDescriptionForEvent(function (string $eventName) {
                return "Role {$eventName} successfully";
            });
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $attributes = [
            'old' => [],
            'new' => [],
        ];

        if ($eventName === 'created') {
            $attributes['new'] = $this->attributesToArray();
        } elseif ($eventName === 'updated') {
            $attributes['old'] = $this->getOriginal();
            $attributes['new'] = $this->attributesToArray();
        } elseif ($eventName === 'deleted') {
            $attributes['old'] = $this->getOriginal();
        }
        $attributes['old'] = $this->formatTimestamps($attributes['old']);
        $attributes['new'] = $this->formatTimestamps($attributes['new']);

        $activity->properties = ['attributes' => $attributes];
    }
    protected $fillable = ['name', 'permissions'];
    protected function formatTimestamps(array $attributes): array
    {
        foreach (['created_at', 'updated_at'] as $key) {
            if (isset($attributes[$key])) {
                try {
                    $attributes[$key] = \Carbon\Carbon::parse($attributes[$key])->format('Y-m-d H:i:s');
                } catch (\Exception $e) {

                }
            }
        }

        return $attributes;
    }

    // public $appends = ['title'];

    protected $casts = [
        'permissions' => 'array',
    ];


    public function users()
    {
        $this->hasMany(User::class);
    }


}
