<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectForm extends Model
{
    use HasFactory;

    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function form()
    {
        return $this->belongsTo(Form::class, 'form_id');
    }
    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }

    public function projectFormInputs()
    {
        return $this->hasMany(ProjectInput::class,'project_form_id');
    }

    public function users()
    {
        return $this->belongsTo(User::class,'user_id');
    }




}
