<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormRow extends Model
{
    use HasFactory;
    protected $fillable = [
        'form_id',
        'single_multi_column',
        'single_multi_input',
    ];

    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    public function getColumn()
    {
        return $this->hasMany(FormColumn::class, 'form_row_id')->with('getFormInput','getsubRows');
    }

    public function getProjectColumn()
    {
        return $this->hasMany(FormColumn::class, 'form_row_id')->with('getProjectsInput');
    }

    public function getProjectInputs()
    {
        return $this->hasMany(ProjectInput::class,'form_row_id');
    }

    public function columns()
    {
        return $this->hasMany(FormColumn::class, 'form_row_id')->with('inputs.options');
    }
}
