<?php

namespace App\Models\FormGroupArrange;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Form;
use App\Models\FormGroup\FormGroup;

class FormGroupArrange extends Model
{
    use HasFactory;

    protected $fillable = [
        'form_id',
        'form_group_id',
        'order_of_cycle',
        'order_of_arrangement',
    ];

    /**
     * Get the form associated with this arrangement.
     */
    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    /**
     * Get the form group associated with this arrangement.
     */
    public function formGroup()
    {
        return $this->belongsTo(FormGroup::class);
    }
}
