<?php

namespace App\Models\FormGroup;

use App\Models\Form;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class FormGroup extends Model
{
    use HasFactory, LogsActivity;
    protected static $logAttributes = ['*'];

    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(static::$logAttributes)
            ->logOnlyDirty()
            ->useLogName('group')
            ->dontSubmitEmptyLogs();
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $attributes = [
            'old' => [],
            'new' => [],
        ];

        if ($eventName === 'created') {
            $attributes['new'] = $this->getAttributes();
        } elseif ($eventName === 'updated') {
            $attributes['old'] = $this->getOriginal();
            $attributes['new'] = $this->getAttributes();
        } elseif ($eventName === 'deleted') {
            $attributes['old'] = $this->getOriginal();
        }

        $attributes['old'] = $this->formatTimestamps($attributes['old']);
        $attributes['new'] = $this->formatTimestamps($attributes['new']);
        $activity->properties = ['attributes' => $attributes];
    }

    protected function formatTimestamps(array $attributes): array
    {
        foreach (['created_at', 'updated_at'] as $key) {
            if (isset($attributes[$key])) {
                try {
                    $attributes[$key] = \Carbon\Carbon::parse($attributes[$key])->format('Y-m-d H:i:s');
                } catch (\Exception $e) {

                }
            }
        }

        return $attributes;
    }
    protected $fillable = [
        'name',
        'paper_type',
    ];
    public function forms()
    {
        return $this->hasMany(Form::class)->where('disable','=',0);
    }

}
