<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormColumn extends Model
{
    use HasFactory;

    public function getFormInput()
    {
        return $this->hasMany(FormInput::class, 'form_column_id')->with('getOption');
    }
    public function getProjectsInput()
    {
        return $this->hasMany(ProjectInput::class, 'form_column_id')->with('inputs');
    }

    public function row()
    {
        return $this->belongsTo(FormRow::class, 'form_row_id');
    }

    public function inputs()
    {
        return $this->hasMany(FormInput::class, 'form_column_id');
    }

    public function getsubRows()
    {
        return $this->hasMany(FormSubRow::class,'column_id')->with('getSubColumn');
    }
}
