<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class Branch extends Model
{
    use HasFactory, SoftDeletes;


    protected static $logAttributes = ['*'];

    protected static $recordEvents = ['deleted'];

    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;

    // Temporary store for old relations
    protected static $oldRelations = [];


    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function projects()
    {
        return $this->hasMany(Project::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'user_branches', 'branch_id', 'user_id');
    }

    public function get_form_branch_project()
    {
        return $this->hasMany(FormBranchProject::class, 'branch_id');
    }

    public function getProjectForm()
    {
        return $this->hasMany(ProjectForm::class, 'branch_id');
    }

}
