<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RowsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "single_multi_column" => $this->single_multi_column,
            "single_multi_input" => $this->single_multi_input,
            "type_row" => $this->type_row,
            "columns" =>ColumnsResource::collection(
                $this->whenLoaded('getColumn') ?
                    $this->getColumn->map(function ($me) {
                        return new ColumnsResource($me);
                    }) :
                    null
            )
        ];
    }
}
