<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name'=>$this->name,
            'branch_id'=>$this->branch->id ?? null,
            'branch_name'=>$this->branch->name ?? null,
            'user_id'=>$this->user_id,
            'user_name'=>$this->creator ? $this->creator->name : null, // Get the user's name
        ];
    }
}
