<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InputsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "id"=>$this->id,
            "label" => $this->label,
            "input_type" => $this->input_type,
            "calculated" => $this->calculated,
            "placeholder" => $this->placeholder,
            "file_type" => $this->file_type,
            "value" => $this->value,
            "required" => $this->required,
            "chart" => $this->chart,
            "show_pdf"=>$this->show_pdf,
            "show_on_fill"=>$this->show_on_fill,
            "chart_type" => $this->chart_type,
            "icon" => $this->icon,
            "writing_mode" => $this->writing_mode,
            "options" =>OptionsResource::collection(
        $this->whenLoaded('getOption') ?
            $this->getOption->map(function ($me) {
                return new OptionsResource($me);
            }) :
            null
    )
        ];
    }
}
