<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FormRelatedResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'form_id'=>$this->form_id,
            'form_name'=>$this->form->name,
            'form_type'=>$this->form->type,
            'form_group_id'=>$this->form->form_group_id,
            'form_group_name'=>$this->form->formGroup->name ?? null,
            'related_id'=>$this->related_id,
            'related_type'=>$this->related->type,
            'related_name'=>$this->related->name,
            'related_group_id'=>$this->related->form_group_id,
            'related_group_name'=>$this->related->formGroup->name ?? null,
            'user_id'=>$this->user_id,
            'user_name'=>$this->creator->name ?? null,
        ];
    }
}
