<?php

namespace App\Http\Resources\FormGroup;

use App\Http\Resources\FormsResource;
use Illuminate\Http\Resources\Json\JsonResource;

class FormGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'         => $this->id,
            'name'       => $this->name,
            'paper_type' => $this->paper_type,
            'forms'      => FormsResource::collection($this->whenLoaded('forms')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
