<?php

namespace App\Http\Resources\ComplexFormGroupResource;

use App\Http\Resources\FormsResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ComplexFormGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id'               => $this->id,
            'form_id'          => $this->form_id,
            'project_form_id'  => $this->project_form_id,
            'project_id'       => $this->project_id,
            'branch_id'        => $this->branch_id,
            'baranch_name'        => $this->branch->name ?? null,
            'project_name'        => $this->branch->name ?? null,
            'form_group_id'    => $this->form_group_id,
            'status'           => $this->status,
            'parent_id'        => $this->parent_id == 0 ? $this->id:$this->parent_id,
            'reference_code'   => $this->reference_code,
            'user_id' => $this->user_id,
            'user_name' => $this->creator ? $this->creator->name : null,
            'created_at'       => $this->created_at,
            'updated_at'       => $this->updated_at,
            'department_ids'   => $this->form && $this->form->relationLoaded('departments')
                ? $this->form->departments->pluck('id')
                : [],
            'form'             => new FormsResource($this->whenLoaded('form')),
        ];
    }
}
