<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ColumnsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "width"=>$this->width,
            "column_type"=>$this->column_type,

           /* 'inputs'=>InputsResource::collection(
                $this->whenLoaded('getFormInput') ?
                    $this->getFormInput->map(function ($me) {
                        return new InputsResource($me);
                    }) :
                    null
            ),*/
            'inputs'=>InputsResource::collection(
                ($this->whenLoaded('getFormInput') &&
                    (!$this->relationLoaded('getsubRows') || $this->getsubRows->isEmpty())) ?
                    $this->getFormInput->map(fn($me) => new InputsResource($me)) :
                    []
            ),
            "sub_rows"=>SubRowsResource::collection(
                $this->whenLoaded('getsubRows') ?
                    $this->getsubRows->map(function ($me) {
                        return new SubRowsResource($me);
                    }) :
                    null
            )
        ];
    }
}
