<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class FormCreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'type' => 'required|in:general,fixed',
            'periodic_oneTime' => 'required|in:oneTime,periodic',
            'periodic_type' => 'nullable|in:daily,weekly,monthly,quarterly',
            'deadline_by_num_of_days' => 'nullable|integer|min:1',
            'week_day' => 'nullable|integer|between:1,7',
            'month_day' => 'nullable|integer|between:1,31',
            'quarter_start_day' => 'nullable|integer|min:1',
            'next_send_date' => 'nullable|date',
            'approved' => 'nullable|boolean',
            'title_print' => 'nullable|string|max:255',
            'footer_print' => 'nullable|string|max:255',
            'chart' => 'nullable|boolean',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'status' => 400,
            'message' =>'errors',
            'errors'=>$validator->errors()
        ], 200));
    }
}
