<?php

namespace App\Http\Middleware;

use App\Models\User;
use App\Sys\ApiResponse;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    use ApiResponse;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::user() && Auth::user()->userType === 'admin') {
            return $next($request);
        }
        return $this->apiResponse(403, "error", ['Unauthorized. Admin access only.'], null);
    }
}
