<?php

namespace App\Http\Controllers;

use App\Sys\ApiResponse;
use App\Sys\Services\User\UserService;
use Illuminate\Http\Request;

class UserController extends Controller
{
    use ApiResponse;

    private $userService;

    public function __construct()
    {
        $this->userService = new UserService();
    }

    public function getByid($id)
    {
        $user = $this->userService->getByid($id);
        return $this->apiResponse(200, "success", null, $user);
    }

    public function updateUser(Request $request, $userId)
    {

        $data = $request->all();
        $result = $this->userService->updateUserData($userId, $data);
        if (!$result) {
            $errors = $this->userService->errors();
            return $this->apiResponse(400, "error", $errors, null);
        }
        return $this->apiResponse(200, "success", null, $result);
    }

    public function getAllUsers(Request $request)
    {
        $perPage = $request->get('perPage', 10);
        $users = $this->userService->getAllUsers($perPage);
        return $this->apiResponse(200, "success", null, $users);
    }

    public function searchUsers()
    {
        $users = $this->userService->searchUsers();
        return $this->apiResponse(200, "success", null, $users);
    }

    public function getUserByType($type)
    {
        $users = $this->userService->getUserByType($type);
        return $this->apiResponse(200, "success", null, $users);
    }
}
