<?php

namespace App\Http\Controllers\StaticPage;

use App\Http\Controllers\Controller;
use App\Http\Resources\StaticPage\StaticPageResource;
use App\Sys\ApiResponse;
use App\Sys\Services\StaticPage\StaticPageService;
use Illuminate\Http\Request;
use Exception;

class StaticPageController extends Controller
{
    use ApiResponse;

    private $staticPageService;

    public function __construct()
    {
        // Initialize the service layer.
        $this->staticPageService = new StaticPageService();
    }

    public function index()
    {
        try {
            $pages = $this->staticPageService->get();
            $collect = StaticPageResource::collection($pages);
            return $this->apiResponse(200, 'Static Pages retrieved successfully', null, $collect);
        } catch (Exception $e) {
            return $this->apiResponse(500, 'Error retrieving static pages', [$e->getMessage()], null);
        }
    }

    public function store(Request $request)
    {
        try {
            // Get all input data.
            $data = $request->all();
            $result = $this->staticPageService->add($data);

            if ($result === false) {
                // Retrieve errors from the service.
                $errors = $this->staticPageService->errors();
                return $this->apiResponse(400, 'Error creating static page', $errors, null);
            }

            $collect = new StaticPageResource($result);
            return $this->apiResponse(200, 'Static Page created successfully', null, $collect);
        } catch (Exception $e) {
            return $this->apiResponse(400, 'Error creating static page', [$e->getMessage()], null);
        }
    }

    public function show($id)
    {
        try {
            $page = $this->staticPageService->getByid($id);
            $collect = new StaticPageResource($page);
            return $this->apiResponse(200, 'Static Page retrieved successfully', null, $collect);
        } catch (Exception $e) {
            return $this->apiResponse(404, 'Static Page not found', [$e->getMessage()], null);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $data = $request->all();
            // Append the id to the data.
            $data['id'] = $id;
            $result = $this->staticPageService->updated($data);

            if ($result === false) {
                $errors = $this->staticPageService->errors();
                return $this->apiResponse(400, 'Error updating static page', $errors, null);
            }

            $collect = new StaticPageResource($result);
            return $this->apiResponse(200, 'Static Page updated successfully', null, $collect);
        } catch (Exception $e) {
            return $this->apiResponse(400, 'Error updating static page', [$e->getMessage()], null);
        }
    }

    public function destroy($id)
    {
        try {
            if ($this->staticPageService->del($id)) {
                return $this->apiResponse(200, 'Static Page deleted successfully', null, null);
            }
            $errors = $this->staticPageService->errors();
            return $this->apiResponse(400, 'Error deleting static page', $errors, null);
        } catch (Exception $e) {
            return $this->apiResponse(400, 'Error deleting static page', [$e->getMessage()], null);
        }
    }
}
