<?php

namespace App\Http\Controllers\Projects;

use App\Http\Controllers\Controller;
use App\Http\Resources\ProjectsCollection;
use App\Sys\ApiResponse;
use App\Sys\Services\ProjectsServices\ProjectsServices;
use Illuminate\Http\Request;

class ProjectsControllers extends Controller
{
    use ApiResponse;

    private $project;

    public function __construct()
    {
        $this->project = new ProjectsServices();
    }

    public function getByBranchId($id = 0)
    {
        $projects = $this->project->getByBranchId($id);
        $collection = new  ProjectsCollection($projects);
        return $this->apiResponse(200, 'get project by branchs', null, $collection);
    }

    public function projectUsers(Request $request)
    {
        if($this->project->addUsers($request->all()))
            return $this->apiResponse(200, 'add', null, null);


        $errors = $this->project->errors();
        return $this->apiResponse(400, 'errors', $errors, null);

    }

    public function getProjects()
    {
        $projects = $this->project->getProjects();
        $collection = new  ProjectsCollection($projects);
        return $this->apiResponse(200, 'get project by branchs', null, $collection);
    }


    public function createProject(Request $request)
    {
        if($this->project->createProject($request->all()))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->project->errors();
        return $this->apiResponse(400,'errors',$errors,null);
    }

    public function showProject($id)
    {
        $project = $this->project->getProjectById($id);
        if(!$project){
            return $this->apiResponse(400, "error", "project not found", null);
        }
        return $this->apiResponse(200, "success", null, $project);
    }

    public function updateProject(Request $request)
    {
        if($this->project->updateProject($request->all()))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->project->errors();
        return $this->apiResponse(400,'errors',$errors,null);
    }

    public function del($id)
    {
        if($this->project->del($id))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->project->errors();
        return  $this->apiResponse(400,'errors',$errors,null);
    }
}
