<?php

namespace App\Http\Controllers;

use App\Http\Resources\FormRelatedCollection;
use App\Sys\ApiResponse;
use App\Sys\Services\FormProjectRelatedServices;
use Illuminate\Http\Request;

class FormProjectRelatedControllers extends Controller
{
    use ApiResponse;

    private $formProjectService;
    public function __construct()
    {
        $this->formProjectService = new FormProjectRelatedServices();
    }

    public function add(Request $request)
    {
        if($this->formProjectService->add($request->all()))
            return $this->apiResponse(200, 'Form Project Related Created Successfully');

        return $this->apiResponse(200, 'Failed to Create Form Project Related',$this->formProjectService->errors(),null);
    }

    public function del($id)
    {
        if($this->formProjectService->del($id))
            return $this->apiResponse(200, 'Form Project Related Deleted Successfully');

        return $this->apiResponse(200, 'Failed to Delete Form Project Related',$this->formProjectService->errors(),null);
    }

    public function get($id)
    {
        $forms = $this->formProjectService->get($id);
        $collect = new FormRelatedCollection($forms);
        return $this->apiResponse(200, 'Form Project Related Fetched Successfully',null,$collect);

    }

}
