<?php

namespace App\Http\Controllers\DepartmentForm;

use App\Http\Controllers\Controller;
use App\Sys\ApiResponse;
use App\Sys\Services\DepartmentForm\DepartmentFormService;
use Illuminate\Http\Request;
use Exception;

class DepartmentFormController extends Controller
{
    use ApiResponse;

    protected $deptFormService;

    public function __construct()
    {
        $this->deptFormService = new DepartmentFormService();
    }

    /**
     * Attach a department to a form.
     *
     * Expected request body:
     * {
     *     "form_id": 1,
     *     "department_id": 3,
     *     "form_group_id": 5   // optional
     * }
     *
     */
    public function attachDepartment(Request $request)
    {
            if($updatedForm = $this->deptFormService->attachDepartment($request))
            {
                return $this->apiResponse(200, 'Department attached to form successfully.', null, $updatedForm);
            }
            return $this->apiResponse(400, 'Error', $this->deptFormService->errors(), null);
    }

    /**
     * Detach a department from a form.
     *
     * Expected request body:
     * {
     *     "form_id": 1,
     *     "department_id": 3
     * }
     *
     */
    public function detachDepartment(Request $request)
    {
        try {
            // The service returns the updated form data.
            $updatedForm = $this->deptFormService->detachDepartment($request);
            return $this->apiResponse(200, 'Department detached from form successfully.', null, $updatedForm);
        } catch (Exception $ex) {
            return $this->apiResponse(400, 'Error', $ex->getMessage(), null);
        }
    }
}
