<?php

namespace App\Http\Controllers\Department;

use App\Http\Controllers\Controller;
use App\Http\Resources\DepartmentCollection;
use App\Http\Resources\DepartmentResource;
use App\Sys\ApiResponse;
use App\Sys\Services\Department\DepartmentServices;
use Illuminate\Http\Request;

class departmentControllers extends Controller
{
    use ApiResponse;
    private $depSer;

    public function __construct()
    {
        $this->depSer = new DepartmentServices();
    }

    public function get()
    {
        $department = $this->depSer->get();
        $collect = new DepartmentCollection($department);
        return $this->apiResponse(200,'department',null,$collect);
    }

    public function getByid($id =0)
    {
        $department = $this->depSer->getByid($id);
        $collect = new DepartmentResource($department);
        return $this->apiResponse(200,'department',null,$collect);
    }

    public function add(Request $request)
    {
        if($this->depSer->add($request->all()))
            return $this->apiResponse(200,'add',null,null);

        $errors = $this->depSer->errors();
        return $this->apiResponse(400,'department',$errors,null);
    }

    public function updated(Request $request)
    {
        if($this->depSer->updated($request->all()))
            return $this->apiResponse(200,'add',null,null);

        $errors = $this->depSer->errors();
        return $this->apiResponse(400,'department',$errors,null);
    }

    public function del($id)
    {
        if($this->depSer->del($id))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->depSer->errors();
        return  $this->apiResponse(400,'errors',$errors,null);
    }
}
