<?php

namespace App\Http\Controllers;

use App\Sys\ApiResponse;
use App\Sys\Services\Auth\AuthService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    use ApiResponse;

    protected $authService;

    public function __construct()
    {
        $this->authService = new AuthService();
    }

    public function register(Request $request)
    {
        $result = $this->authService->register($request->all());
        if (!$result) {
            return $this->apiResponse(400, 'error', $this->authService->errors(), null);
        }
        return $this->apiResponse(200, 'done', null, $result);
    }

    public function login(Request $request)
    {
        $credentials = $request->all();
        $result = $this->authService->login($credentials);

        if (!$result) {
            return $this->apiResponse(400, 'error', $this->authService->errors(), null);
        }
        return $this->apiResponse(200, 'done', null, $result);
    }

    public function logout(Request $request)
    {
        if ($this->authService->logout()) {
            return $this->apiResponse(200, 'done', null, null);
        }
        return $this->apiResponse(400, 'error', "There is not loggedIn User!", null);
    }


    public function generateResetToken(Request $request)
    {
        $email = $request->input('email');
        $result = $this->authService->generateResetToken($email);
        if (!$result) {
            return $this->apiResponse(400, 'error', $this->authService->errors(), null);
        }
        return $this->apiResponse(200, 'done', null, $result);
    }

    public function resetPassword(Request $request)
    {
        $result = $this->authService->resetPassword($request->all());
        if (!$result) {
            return $this->apiResponse(400, 'error', $this->authService->errors(), null);
        }
        return $this->apiResponse(200, 'done', null, $result);
    }

    public function refresh(Request $request)
    {
        try {
            $token = auth()->guard('api')->refresh();
            $user = Auth::user();
            $user->load('projects', 'branches','departments','role');
            $expiresAt = now()->addMinutes(auth()->factory()->getTTL())->toDateTimeString();
            return $this->apiResponse(200, 'done', null, data: [
                'user' => $user,
                'token' => 'Bearer ' . $token,
                'expires_at' => $expiresAt,
            ]);
        } catch (\Exception $exception) {
            return $this->apiResponse(400, 'error', ['Token refresh failed'], null);
        }
    }
}
