<?php

namespace App\Console;

use App\Sys\Services\Form\FormService;
use App\Sys\Services\ProjectsFroms\ProjectsFormServices;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class PublishProjectFormCronCommand extends Command
{
    protected $signature = 'publish:project-form-cron';

    protected $description = 'Command description';

    public function handle()
    {
        // get From next_date = this day
         $fromServices = new FormService();
         $forms = $fromServices->FromByNextDate(Carbon::now()->format('Y-m-d'));
         foreach ($forms as $form)
         {
             // send
             $send = new ProjectsFormServices();
              $send->addProjectFrom($form);
             //updated next date
             $fromServices->updatedNextDate($form);
         }

        Log::info("publish Form Cron is working fine!");
        return Command::SUCCESS;
    }
}
