<?php

namespace App\Console;

use Illuminate\Console\Command;
use App\Models\ProjectForm;
use Carbon\Carbon;

class ExpireGeneralProjectForms extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expire:project-forms';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update the status of general project forms to expired if their expiration date has passed and they are in waiting status';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $now = Carbon::now();

        // Query project forms with type "general" that are in waiting status and whose expiration date has passed
        $expiredForms = ProjectForm::where('type', 'general')
            ->whereIn('status', ['waiting', 'waiting_approved'])
            ->whereNotNull('expiration_date')
            ->where('expiration_date', '<', $now)
            ->get();

        $this->info("Found " . $expiredForms->count() . " expired forms.");

        foreach ($expiredForms as $form) {
            $form->status = 'expired';
            $form->save();
            $this->info("Project form ID {$form->id} marked as expired.");
        }

        return 0;
    }
}
