<?php

namespace App\Sys\Services\ProjectsServices;

use App\Models\UserProject;
use App\Sys\ApiResponse;
use App\Sys\Repository\Projects\ProjectsRepo;
use App\Sys\Services;
use Illuminate\Support\Facades\DB;
use validator;
use Illuminate\Validation\Rule;

class ProjectsServices extends Services
{
    use ApiResponse;

    private $project;


    public function __construct()
    {
        $this->project = new ProjectsRepo();
    }


    public function getByBranchId($id)
    {
        return $this->project->getByBranchId($id);
    }

    public function createProject($data)
    {

        $rules = [
            'name' => 'required|string|max:255|unique:projects,name',
            'branch_id' => 'required|exists:branches,id',
            'user_id' => 'nullable',
            'user_id.*' => 'numeric|exists:users,id',
            'forms' => 'nullable',
            'forms.*' => 'numeric|exists:forms,id',
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }
        return $this->project->createProject($data);
    }

    public function getProjectById($id)
    {
        return $this->project->getProjectById($id);
    }

    public function updateProject($data)
    {
        $rules = [
            'id' => 'required|integer|exists:projects,id',
            'name' => 'required|string|max:255|unique:projects,name,' . $data['id'],
            'branch_id' => 'required|exists:branches,id',
            'user_id' => 'nullable',
            'user_id.*' => 'numeric|exists:users,id',
            'forms' => 'nullable',
            'forms.*' => 'numeric|exists:forms,id',
        ];

        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }
        return $this->project->updateProject($data);
    }

    public function addUsers($data)
    {
        $rules = [
            'user_project' => 'required|array',
            'user_project.*.user_id' => [
                'required',
                Rule::exists('users', 'id'),
            ],
            'user_project.*.project_id' => 'required|exists:projects,id'
        ];

        $valid = validator($data, $rules);

        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return $this->project->adduserProject($data);
    }

    public function getProjects()
    {
        return $this->project->all();
    }

    public function del($id)
    {
        $del = $this->project->getProjectById($id);
        if (!empty($del))
            return $this->project->del($id);


        $this->setError('Not Found');
        return  false;
    }

    public function count()
    {
        return $this->project->count();
    }
}
