<?php

namespace App\Sys\Services\BranchesServices;

use App\Sys\ApiResponse;
use App\Sys\Repository\Branches\BranchesRepo;
use App\Sys\Services;
use Illuminate\Validation\Rule;
use validation;

class BranchesServices extends Services
{
    use ApiResponse;

    private $branch;

    public function __construct()
    {
        $this->branch = new BranchesRepo();
    }

    public function getAll()
    {
        return $this->branch->getAll();
    }

    public function pluckAll() {}

    public function createBranch($data)
    {

        $rules = [
            'name' => 'required|string|max:255|unique:branches,name',
            'user_id' => 'nullable',
            'user_id.*' => 'numeric|exists:users,id',
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }
        return $this->branch->createBranch($data);
    }

    public function getBranchById($id)
    {
        return $this->branch->findBranchById($id);
    }

    public function updateBranch($data)
    {
        $rules = [
            'id' => 'required|integer|exists:branches,id',
            'name' => 'required|string|max:255|unique:branches,name,' . $data['id'],
            'user_id' => 'nullable',
            'user_id.*' => 'numeric|exists:users,id'
        ];
        $valid = validator($data, $rules);
        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }
        return $this->branch->updateBranch($data);
    }

    public function addUsers($data)
    {
        $rules = [
            'user_branch' => 'required|array',
            'user_branch.*.user_id' =>
            [
                'required',
                Rule::exists('users', 'id')->where('userType', 'branch'),
            ],
            'user_branch.*.branch_id' => 'required|exists:branches,id'
        ];

        $valid = validator($data, $rules);

        if ($valid->fails()) {
            $this->setError($valid->errors());
            return false;
        }

        return $this->branch->adduserProject($data);
    }

    public function del($id)
    {
        $del = $this->branch->getbyid($id);
        if (!empty($del))
            return $this->branch->del($id);


        $this->setError('Not Found');
        return  false;
    }
    public function count()
    {
        return $this->branch->count();
    }
}
