<?php

namespace App\Sys\Repository\ProjectsForms;

use App\Models\Branch;
use App\Models\formComplexGroups;
use App\Models\FormInputOption;
use App\Models\FormRow;
use App\Models\ProjectForm;
use App\Models\ProjectInput;

class ProjectsFormsRepo
{

    public function count()
    {
        return ProjectForm::count();
    }

    public function SendForm($data)
    {

        $form = new ProjectForm();
        $form->project_id = $data['project_id'];
        $form->form_id = $data['form_id'];
        $form->branch_id = $data['branch_id'];
        $form->type = $data['type'];
        $form->expiration_date = $data['expiration_date'];
        $form->chart = $data['chart'];
        $form->approved = $data['approved'];
        $form->status = $data['status'];
        $form->reference_code = $data['ref'] ?? null;
        $form->user_id =$data['type'] == "general" ? null : (optional(auth())->id() ?? ($data['user_id'] ?? null));
        $form->save();
        return $form->id;
    }

    public function getData()
    {
        $name = request()->form_name;
        $type = request()->type;
        $status = request()->has('status') && request()->status !== null ? explode(',', request()->status) : null;
        $branch = request()->has('branch') && request()->branch !== null ? explode(',', request()->branch) : null;
        $project = request()->has('project') && request()->project !== null ? explode(',', request()->project) : null;
        $from = request()->from;
        $to = request()->to;
        $users_project = request()->has('user_project') && request()->user_project !== null ? explode(',', request()->user_project) : null;
        $users_branch = request()->has('user_branch') && request()->user_branch !== null ? explode(',', request()->user_branch) : null;
        $phone_user = request()->phone_user;
        $user_id=request()->user_id;
        $limit = request()->limit;
        $id = request()->id;


        return ProjectForm::with('form', 'project', 'branch','creator')->when($type, function ($q) use ($type) {
            $q->where('type', $type);
        })->when($branch, function ($q) use ($branch) {
            $q->whereIn('branch_id', $branch);
        })->when($id, function ($q) use ($id) {
            $q->where('id', $id);
        })->when($project, function ($q) use ($project) {
            $q->whereIn('project_id', $project);
        })->when($status, function ($q) use ($status) {
            $q->whereIn('status', $status);
        })->when($user_id, function ($q) use ($user_id) {
            $q->where('user_id', $user_id);
        })->when($name, function ($q, $name) {
            $q->whereHas('form', function ($q) use ($name) {
                $q->where('name', 'like', '%' . $name . '%');
            });
        })->when($users_project, function ($q, $users_project) {
            $q->whereHas('project.users', function ($q) use ($users_project) {
                $q->whereIn('users.id', $users_project);
            });
        })->when($users_branch, function ($q, $users_branch) {
            $q->whereHas('branch.users', function ($q) use ($users_branch) {
                $q->whereIn('users.id', $users_branch);
            });
        })->when($phone_user, function ($q, $phone_user) {
            $q->whereHas('project.users', function ($q) use ($phone_user) {
                $q->where('users.phone', $phone_user);
            })->orWhereHas('branch.users', function ($q) use ($phone_user) {
                $q->where('users.phone', $phone_user);
            });
        })->when($from && $to, function ($q) use ($from, $to) {
            $q->whereBetween('created_at', [$from, $to]);
        })->orderBy('project_forms.updated_at', 'desc')->paginate($limit);
    }

    public function getInputsForForm($id)
    {

        /*
        return FormRow::whereHas('getProjectInputs', function ($query) use ($id) {
            $query->where('project_form_id', $id);
        })->where('type_row', 'td')
            ->whereHas('getProjectColumn.getProjectsInput', function ($query) use ($id) {
                $query->where('project_form_id', $id);
            })
            ->with([
                'getProjectColumn.getProjectsInput' => function ($query) use ($id) {
                    $query->where('project_form_id', $id);
                }
            ])->paginate(1, ['*'], 'page', $page);
        */

        return FormRow::whereHas('getProjectInputs', function ($query) use ($id) {
            $query->where('project_form_id', $id);
        })->where('type_row', 'td')
            ->with([
                'getProjectInputs' => function ($query) use ($id) {
                    $query->where('project_form_id', $id);
                }
            ])->get();
    }

    public function updatedProjectInput($data, $name)
    {
        $named = in_array($data['type'], ['checkbox', 'radio']) ? $this->getOptionNamed($data['value']) : null;
        $project = ProjectInput::find($data['id']);
        $project->answer = $name != null ? $name : $data['value'];
        $project->answer_named = $named;
        $project->file_type = $data['file_type'] ?? null;
        return $project->save();
    }

    public function getOptionNamed($ids)
    {
        $array = $this->normalizeValue($ids);
        if (!empty($array)) {
            $options = FormInputOption::whereIn('id', $array)->get();
            $name = '';
            foreach ($options as $option) {
                $name .= $option->name . ' / ';
            }
            return $name = rtrim($name, " / ");
        }

        return null;
    }

    function normalizeValue($value)
    {
        if (is_int($value)) {
            return [$value]; // إذا كانت القيمة عددًا صحيحًا، نضعها في مصفوفة
        }

        if (is_string($value)) {
            $decoded = json_decode($value, true);
            if (is_array($decoded)) {
                return array_map('intval', $decoded); // تحويل جميع العناصر إلى int
            }
            return [(int)$value]; // تحويل القيمة النصية إلى عدد صحيح داخل مصفوفة
        }

        if (is_array($value)) {
            return array_map('intval', $value); // التأكد من أن جميع القيم داخل المصفوفة أعداد صحيحة
        }

        return [];
    }

    public function checkFroNullInput($id)
    {
        return ProjectInput::where([
            ['project_form_id', $id],
            ['required', 1],
            ['answer', null]
        ])->whereNotIn('input_type', ['label', 'creator', 'approver'])->first();
    }

    public function approveForm($id)
    {
        $form = ProjectForm::with('form','project','branch')->find($id);
        $form->user_id = auth()->user()->id() ?? null;
        $form->status = 'approved';
        $form->save();
        ProjectInput::where([['project_form_id', $id],['input_type','approver']])->update(['answer' => auth()->user()->name]);
        $inputs = ProjectInput::with('inputs')->where('project_form_id',$id)->whereNotIn('input_type', ['label', 'creator', 'approver'])->get();
        $input =[];
        foreach ($inputs as $inp)
        {
            $input[]=[
                'id'=>$inp->id,
                'label'=>$inp->inputs->label,
                'input_type'=>$inp->input_type,
                'answer'=>$this->getAnswer($inp),
                'file_type'=>$inp->file_type,
                'updated_at'=>$inp->updated_at->format('Y-m-d H:i:s')
            ];
        }
        $attrib =[
            'id'=>$form->id,
            'form_name'=>$form->form->name,
            'status'=>$form->status,
            'project_name'=>$form->project->name ?? null,
            'branch_name'=>$form->branch->name ?? null,
            'updated_at'=>$form->updated_at->format('Y-m-d H:i:s'),
            'inputs'=>$input
        ];

        activity('project_form')
            ->performedOn($form)
            ->causedBy(auth()->user())
            ->event('updated')
            ->withProperties([
                'attributes' => [
                    $attrib
                ]
            ])
            ->log($form->form->name);

        return $form;
    }
    public function updatedForms($id)
    {
        $form = ProjectForm::with('form','project','branch')->find($id);
        $form->status = $form->approved == 1 ? "waiting_approved" : "done";
        $form->user_id = auth()->id() ?? ($data['user_id'] ?? null);
        $form->save();
         //logs
        ProjectInput::where([['project_form_id', $id],['input_type','creator']])->update(['answer' => auth()->user()->name]);
        $inputs = ProjectInput::with('inputs')->where('project_form_id',$id)->whereNotIn('input_type', ['label', 'creator', 'approver'])->get();
        $input =[];
        foreach ($inputs as $inp)
        {
            $input[]=[
                'id'=>$inp->id,
                'label'=>$inp->inputs->label,
                'input_type'=>$inp->input_type,
                'answer'=>$this->getAnswer($inp),
                'file_type'=>$inp->file_type,
                'updated_at'=>$inp->updated_at->format('Y-m-d H:i:s')
            ];
        }
        $attrib =[
            'id'=>$form->id,
            'form_name'=>$form->form->name,
            'status'=>$form->status,
            'project_name'=>$form->project->name ?? null,
            'branch_name'=>$form->branch->name ?? null,
            'updated_at'=>$form->updated_at->format('Y-m-d H:i:s'),
            'inputs'=>$input
        ];

        activity('project_form')
            ->performedOn($form)
            ->causedBy(auth()->user())
            ->event('updated')
            ->withProperties([
                'attributes' => [
                    $attrib
                ]
            ])
            ->log($form->form->name);

        return $form;
    }


    private function getAnswer($input)
    {
        $answer =null;
        if(in_array($input->input_type,['checkbox','radio']))
            $answer = $input->answer_named;
        elseif ($input->input_type == 'file')
            $answer = url($input->answer);
        else
            $answer = $input->answer;


        return $answer;
    }



    public function getProjectForm($id)
    {
        return ProjectForm::with('form.files','creator')->find($id);
    }

    public function FormChartFixed($id)
    {

        return $branches = Branch::whereHas('getProjectForm', function ($query) use ($id) {
            $query->where('form_id', $id);
        })->with([
                'getProjectForm' => function ($query) use ($id) {
                    $query->where('form_id', $id);
                },
                'getProjectForm.projectFormInputs.inputs'
            ])->get();
    }

    public function getChart($data)
    {
        $branch = $data['branch_id'];
        $forms = $data['form_id'];
        $input = $data['input_id'];
        $from = $data['from'];
        $to = $data['to'];

        return ProjectForm::
        whereBetween('created_at', [$from, $to])
            ->where([
                ['form_id', $forms],
                ['branch_id', $branch]
            ])
            ->with(['project', 'projectFormInputs' => function ($query) use ($input) {
                $query->where('form_input_id', $input);
            }])->get();
    }

}
