<?php

namespace App\Sys\Repository\Projects;

use App\Models\Branch;
use App\Models\Form;
use App\Models\FormBranchProject;
use App\Models\Project;
use App\Models\User;
use App\Models\UserBranch;
use App\Models\UserProject;
use App\Sys\LogsModelActivity;
use App\Sys\Repository\Forms\FormBranchProjectRepo;
use Illuminate\Support\Facades\DB;

class ProjectsRepo
{
    use LogsModelActivity;

    private $project;


    public function __construct()
    {
        $this->project = new Project();
    }


    // get project by branch id
    public function getByBranchId($id)
    {
        return $this->project->with('creator', 'branch', 'users')->where('branch_id', $id)->get();
    }

    public function createProject($data)
    {
        $project = new Project();
        $project->name = $data['name'];
        $project->branch_id = $data['branch_id'];
        $project->user_id = auth()->id();
        $project->save();
        $forms = collect();
        if (!empty($data['user_id']) && is_array($data['user_id'])) {
            foreach ($data['user_id'] as $id) {
                $userProject = new UserProject();
                $userProject->user_id = $id;
                $userProject->project_id = $project->id;
                $userProject->save();
            }
            $users = User::whereIn('id', $data['user_id'])->get();
        }

        if (!empty($data['forms']) && is_array($data['forms'])) {
            $fbp = new FormBranchProjectRepo();
            foreach ($data['forms'] as $form_id) {
                $fbp->add(['id' => $form_id, 'branch' => $project->branch_id, 'project' => $project->id]);
            }
            $forms = Form::whereIn('id', $data['forms'])->get();
        }
        $branch = Branch::find($project->branch_id);
        $userList = ['old' => [], 'new' => !empty($users) ? $users : collect()];
        $relation = [
            'users' => $userList,
            'branch' => ['old' => [], 'new' => collect($branch)],
            'forms' => ['old' => [], 'new' => $forms],
        ];
        $this->logActivity('project', $project, 'created', $relation);
        return true;
    }

    public function getProjectById($id)
    {
        return Project::with('branch', 'creator', 'users')->find($id);
    }

    public function updateProject($data)
    {
        $project = Project::find($data['id']);
        $originalBranch = clone $project;
        $oldBranch =  Branch::find($project->branch_id);
        $project->name = $data['name'];
        $project->branch_id = $data['branch_id'];
        $project->user_id = auth()->id();
        $project->save();
        $oldUserIds = UserProject::where('project_id', $project->id)->pluck('user_id');
        $oldUsers = !empty($oldUserIds) ? User::whereIn('id', $oldUserIds)->get() : collect();
        $newUsers = collect();
        if (!empty($data['user_id']) && is_array($data['user_id'])) {
            UserProject::where('project_id', $project->id)->delete();
            foreach ($data['user_id'] as $id) {
                $userProject = new UserProject();
                $userProject->user_id = $id;
                $userProject->project_id = $project->id;
                $userProject->save();
            }
            $newUsers = User::whereIn('id', $data['user_id'])->get();
        }
        $newBranch = Branch::find($project->branch_id);
        $this->logActivity('project', $project, 'updated', ['users' => ['old' => $oldUsers, 'new' => $newUsers],'branch' => ['old' => collect($oldBranch), 'new' => collect($newBranch)]],$originalBranch);
        return true;
    }

    public function checkUserProject($value)
    {
        return DB::table('user_projects')
            ->where('user_id', $value['user_id'])
            ->where('project_id', $value['project_id'])
            ->exists();
    }

    public function adduserProject($data)
    {
        foreach ($data['user_project'] as $user) {
            if (!$this->checkUserProject($user)) {
                $prUser = new UserProject();
                $prUser->user_id = $user['user_id'];
                $prUser->project_id = $user['project_id'];
                $prUser->save();
            }

        }

        return true;
    }

    public function all()
    {
        return $this->project->get();
    }

    public function del($id)
    {
        $data = $this->project->find($id);
        $data->delete();
        $this->logActivity('project', $data, 'deleted', []);
        return true;
    }

    public function count()
    {
        return $this->project->count();
    }
}
