<?php

namespace App\Sys\Repository\NotificationBar;

use App\Models\NotificationBar;

class NotificationBarRepo
{
    private $notif;

    public function __construct()
    {
        $this->notif = new NotificationBar();
    }

    /**
     * Retrieve all notification bars.
     */
    public function get()
    {
        return $this->notif->with('creator')->get();
    }

    /**
     * Retrieve only active notification bars.
     */
    public function getActive()
    {
        return $this->notif->with('creator')->where('active', 1)->get();
    }

    /**
     * Create a new notification bar.
     */
    public function create(array $data)
    {
        $data['user_id'] = auth()->id(); // Ensure the user_id is set
        return $this->notif->create($data);
    }

    /**
     * Find a notification bar by its ID.
     */
    public function find($id)
    {
        return $this->notif->with('creator')->findOrFail($id);
    }

    /**
     * Update an existing notification bar.
     */
    public function update($id, array $data)
    {
        $bar = $this->notif->findOrFail($id);
        $data['user_id'] = auth()->id(); // Ensure user_id is updated
        $bar->update($data);
        return $bar;
    }

    /**
     * Delete a notification bar.
     */
    public function delete($id)
    {
        $bar = $this->notif->findOrFail($id);
        $bar->delete();
        return true;
    }
}
