<?php

namespace App\Sys\Repository\Forms;

use App\Models\Branch;
use App\Models\FormBranchProject;
use App\Models\Project;
use function Symfony\Component\Translation\t;

class FormBranchProjectRepo
{
    private $fbpModel;
    private $project;

    private $branch;

    public function __construct()
    {
        $this->branch = new Branch();
        $this->project = new Project();
        $this->fbpModel = new FormBranchProject();
    }

    public function add($data)
    {
        $add = new FormBranchProject();
        $add->form_id = $data['id'];
        $add->branch_id = $data['branch'];
        $add->project_id = $data['project'];
        $add->user_id = auth()->user()->id ??null;

        $add->save();
    }

    public function getByFromID($id)
    {
        return $this->fbpModel->where('form_id',$id)->get();
    }

    public function getAllBrach()
    {
        return $this->branch->pluck('id')->toArray();
    }

    public function getAllProjectByBranch($id)
    {
        return $this->project->where('branch_id',$id)->pluck('id')->toArray();
    }

    public function checkBranch($id)
    {
        return $this->branch->find($id);
    }

    public function allProject()
    {
        return $this->project->all();
    }

    public function checkProject($id)
    {
        return $this->project->find($id);
    }

    public function projects($ids)
    {
        return $this->project->whereIn('id',$ids)->get();
    }
    public function projectsByBranch($id)
    {
        return $this->project->where('branch_id',$id)->get();
    }


}
