<?php

namespace App\Sys\Repository\FormGroup;

use App\Models\FormGroup\FormGroup;

class FormGroupRepository
{

    public function all()
    {
        return FormGroup::with('forms')->orderBy('id', 'DESC')->get();
    }

    public function find($id)
    {
        return FormGroup::with('forms')->findOrFail($id);
    }

    public function create(array $data)
    {
        return FormGroup::create($data);
    }

    public function update($id, array $data)
    {
        $page = $this->find($id);
        $page->update($data);
        return $page;
    }

    public function delete($id)
    {
        $page = $this->find($id);
        $page->delete();
        return true;
    }

    // /**
    //  * Get form groups by department filter.
    //  *
    //  * @param mixed $department Department id (numeric) or department name (string).
    //  * @return \Illuminate\Database\Eloquent\Collection
    //  */

    //  public function getFormsByDepartment($department)
    //  {
    //      return \App\Models\Form::where('order_of_cycle', 1)
    //          ->whereHas('departments', function ($query) use ($department) {
    //              if (is_numeric($department)) {
    //                  $query->where('department.id', $department); // using "department" table name
    //              } else {
    //                  $query->where('department.name', 'like', '%' . $department . '%');
    //              }
    //          })
    //          ->with('formGroup')
    //          ->get();
    //  }

    /**
     * Get forms filtered by department and/or form name with pagination.
     *
     * @param mixed|null $department Department id or name (optional).
     * @param string|null $formName Optional form name to search for.
     * @param int $limit Number of items per page.
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */

    public function getFormsByFilters($departmentIds = null, $formName = null, $limit = 10)
    {
        return \App\Models\Form::query()
            ->where('order_of_cycle', 1)
            ->where('type', 'complex')
            ->when($departmentIds || $formName, function ($query) use ($departmentIds, $formName) {
                $query->where(function ($q) use ($departmentIds, $formName) {
                    if ($departmentIds) {
                        $departmentIds = is_array($departmentIds) ? $departmentIds : [$departmentIds];
                        $q->whereHas('departments', function ($subQuery) use ($departmentIds) {
                            $subQuery->whereIn('department.id', $departmentIds);
                        });
                    }

                    if ($formName) {
                        $q->orWhere('name', 'like', '%' . $formName . '%');
                    }
                });
            })
            ->with(['formGroup', 'departments'])
            ->paginate($limit);
    }
}
