<?php

namespace App\Sys\Repository\Department;

use App\Models\Department;

class DepartmentRepo
{
    private $department;
    public function __construct()
    {
        $this->department = new Department();
    }

    public function add($data)
    {
        $this->department->name = $data['name'];
        $this->department->user_id = auth()->id();
        return $this->department->save();
    }

    public function updated($data)
    {
        $dep = $this->department->find($data['id']);
        $dep->name = $data['name'];
        $dep->user_id = auth()->id();
       return $dep->save();
    }

    public function getAll()
    {
        return $this->department->with('creator')->get();
    }

    public function getByid($id)
    {
        return $this->department->with('creator','users')->find($id);
    }

    public function del($id)
    {
        $data = $this->department->find($id);
        return $data->delete();
    }
}
